/* ///////////////////////////////////////////////////////////////////////// */
/*  This is part of the source of the OMAP 5912 heterogeneous dual-core      */
/*  MPEG-4 SP video decoder published in ACM Transactions on Embedded        */
/*  Computing Systems, Vol. X, Issue Y.                                      */
/* ------------------------------------------------------------------------- */
/*  The source code is released under GPL license.                           */
/*                                                                           */
/*  Copyright, 2011                                                          */
/*  Multimedia Embedded Systems Labs                                         */
/*  Dept. of Computer Science                                                */
/*  National Chiao Tung University                                           */
/*  Hsinchu, Taiwan.                                                         */
/* ///////////////////////////////////////////////////////////////////////// */

/* ***********************************************************
* THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR
* REPRESENTATIONS, EITHER EXPRESS, IMPLIED OR STATUTORY, 
* INCLUDING ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS 
* FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR 
* COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE. 
* TI DISCLAIMS ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET 
* POSSESSION, AND NON-INFRINGEMENT OF ANY THIRD PARTY 
* INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR 
* YOUR USE OF THE PROGRAM.
*
* IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL, 
* CONSEQUENTIAL OR INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY 
* THEORY OF LIABILITY AND WHETHER OR NOT TI HAS BEEN ADVISED 
* OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY OUT 
* OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM. 
* EXCLUDED DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF 
* REMOVAL OR REINSTALLATION, COMPUTER TIME, LABOR COSTS, LOSS 
* OF GOODWILL, LOSS OF PROFITS, LOSS OF SAVINGS, OR LOSS OF 
* USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S 
* AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF 
* YOUR USE OF THE PROGRAM EXCEED FIVE HUNDRED DOLLARS 
* (U.S.$500).
*
* Unless otherwise stated, the Program written and copyrighted 
* by Texas Instruments is distributed as "freeware".  You may, 
* only under TI's copyright in the Program, use and modify the 
* Program without any charge or restriction.  You may 
* distribute to third parties, provided that you transfer a 
* copy of this license to the third party and the third party 
* agrees to these terms by its first use of the Program. You 
* must reproduce the copyright notice and any other legend of 
* ownership on each copy or partial copy, of the Program.
*
* You acknowledge and agree that the Program contains 
* copyrighted material, trade secrets and other TI proprietary 
* information and is protected by copyright laws, 
* international copyright treaties, and trade secret laws, as 
* well as other intellectual property laws.  To protect TI's 
* rights in the Program, you agree not to decompile, reverse 
* engineer, disassemble or otherwise translate any object code 
* versions of the Program to a human-readable form.  You agree 
* that in no event will you alter, remove or destroy any 
* copyright notice included in the Program.  TI reserves all 
* rights not specifically granted under this license. Except 
* as specifically provided herein, nothing in this agreement 
* shall be construed as conferring by implication, estoppel, 
* or otherwise, upon you, any license or other right under any 
* TI patents, copyrights or trade secrets.
*
* You may not use the Program in non-TI devices.
* ********************************************************* */

#ifndef DSPMMU_H
#define DSPMMU_H

// MMU Control Register Addresses
#define PREFETCH_REG 	*((volatile unsigned short *) 0xFFFED200)   // Prefetch register
#define WALKING_ST_REG	*((volatile unsigned short *) 0xFFFED204)   // Prefetch status register
#define CNTL_REG		*((volatile unsigned short *) 0xFFFED208)   // Control register
#define FAULT_AD_H_REG	*((volatile unsigned short *) 0xFFFED20C)   // Fault address register MSB
#define FAULT_AD_L_REG	*((volatile unsigned short *) 0xFFFED210)   // Fault address register LSB
#define F_ST_REG		*((volatile unsigned short *) 0xFFFED214)   // Fault status register
#define IT_ACK_REG		*((volatile unsigned short *) 0xFFFED218)   // shorterrupt acknowledge register
#define TTB_H_REG		*((volatile unsigned short *) 0xFFFED21C)   // TTB register MSB
#define TTB_L_REG		*((volatile unsigned short *) 0xFFFED220)   // TTB register LSB
#define LOCK_REG		*((volatile unsigned short *) 0xFFFED224)   // Lock counter
#define LD_TLB_REG		*((volatile unsigned short *) 0xFFFED228)   // Load entry in TLB
#define CAM_H_REG		*((volatile unsigned short *) 0xFFFED22C)   // CAM entry register MSB
#define CAM_L_REG		*((volatile unsigned short *) 0xFFFED230)   // CAM entry register LSB
#define RAM_H_REG		*((volatile unsigned short *) 0xFFFED234)   // RAM entry register MSB
#define RAM_L_REG		*((volatile unsigned short *) 0xFFFED238)   // RAM entry register LSB
#define GFLUSH_REG		*((volatile unsigned short *) 0xFFFED23C)   // Global flush register
#define FLUSH_ENTRY_REG	*((volatile unsigned short *) 0xFFFED240)   // Individual flush register
#define READ_CAM_H_REG	*((volatile unsigned short *) 0xFFFED244)   // Read CAM register MSB
#define READ_CAM_L_REG	*((volatile unsigned short *) 0xFFFED248)   // Read CAM register LSB
#define READ_RAM_H_REG	*((volatile unsigned short *) 0xFFFED24C)   // Read RAM   register MSB
#define READ_RAM_L_REG	*((volatile unsigned short *) 0xFFFED250)   // Read RAM   register LSB

// Endianess Control Register
#define MMU_EN_CTRL_REG *((volatile unsigned short *) 0xFFFECC34)   // Endianess Control

// Parameters

// Entry Types
#define SECTION 	0x0
#define LARGE_PAGE	0x1
#define SMALL_PAGE	0x2
#define TINY_PAGE	0x3
/*Reference in CAM Entry Register in SWPA038.pdf page 25
00: Section (1M bytes)
01: Large page (64K bytes)
10: Small page (4K bytes)
11: Tiny page (1K bytes) 
*/
// Access Permissions (Bits 9 and 8 of RAM_L_REG)
#define NO_ACCESS	0x000
#define READ_ONLY	0x200
#define READ_WRITE	0x300

// Entry Parameters (Bits 3 and 2 of RAM_L_REG)
#define PRESERVED	0x8
#define VALID		0x4

// TLB Operations
#define READ		0x2
#define	WRITE		0x1

// MMU Control
#define RESET		0x0
#define REL_RESET	0x1
#define	ENABLE		0x2
#define DISABLE		0xFFFD
#define	USE_TABLE	0x4

// Interrupt Acknowledge
#define ACKNOWLEDGE 0x1

typedef struct TLBENTRY
{
    int     VirtualAddress;
    int     PhysicalAddress;
    short   Type;
    short   AccessPermission;
} TLB_ENTRY;

#endif
